
#define IR_NOCODE 0x00000000L
#define IR_REPEAT 0x00800000L
#define IR_CODE(x) ((x)&0xFF7FFFFFL)
#define IR_RC5 0x00010000L
#define IR_NEC 0x00020000L
#define RC5(x) ((x)|IR_RC5)
#define NEC(x) ((x)|IR_NEC)

// codes for Altronics A1012 ("DynaLink") remote control on "TV" setting 156
#define RC5_A1012_STANDBY	0x008C
#define RC5_A1012_MUTE		0x008D

#define RC5_A1012_1			0x0081
#define RC5_A1012_2			0x0082
#define RC5_A1012_3			0x0083
#define RC5_A1012_4			0x0084
#define RC5_A1012_5			0x0085
#define RC5_A1012_6			0x0086
#define RC5_A1012_7			0x0087
#define RC5_A1012_8			0x0088
#define RC5_A1012_9			0x0089
#define RC5_A1012_0			0x0080

#define RC5_A1012_CHUP		0x008A
#define RC5_A1012_CHDN		0x008B
#define RC5_A1012_VOLUP		0x0090
#define RC5_A1012_VOLDN		0x0091

#define RC5_A1012_UP		0x0092
#define RC5_A1012_DOWN		0x0093
#define RC5_A1012_LEFT		0x0095
#define RC5_A1012_RIGHT		0x0094
#define RC5_A1012_OK		0x00A3

#define RC5_A1012_TELETEXT	0x00BF
#define RC5_A1012_PAGEHOLD	0x00A9
#define RC5_A1012_TVVIDEO	0x00AD
#define RC5_A1012_OSD		0x00BE
#define RC5_A1012_RECORD	0x00AE
#define RC5_A1012_PAUSE		0x00B5
#define RC5_A1012_EXIT      0x008B
#define RC5_A1012_RW        0x00B7
#define RC5_A1012_PLAY      0x00B2
#define RC5_A1012_FF        0x00B4
#define RC5_A1012_STOP      0x00B6


// codes for Jaycar AR1729 Digitech Universal remote on "TV" setting 102
#define RC5_AR1729_MUTE     0x000D
#define RC5_AR1729_STANDBY  0x000C

#define RC5_AR1729_1        0x0001
#define RC5_AR1729_2        0x0002
#define RC5_AR1729_3        0x0003
#define RC5_AR1729_4        0x0004
#define RC5_AR1729_5        0x0005
#define RC5_AR1729_6        0x0006
#define RC5_AR1729_7        0x0007
#define RC5_AR1729_8        0x0008
#define RC5_AR1729_9        0x0009
#define RC5_AR1729_1_       0x000A
#define RC5_AR1729_0        0x0000
#define RC5_AR1729_2_       0x000B

#define RC5_AR1729_UP       0x0014
#define RC5_AR1729_DOWN     0x0015
#define RC5_AR1729_LEFT     0x0013
#define RC5_AR1729_RIGHT    0x0012
#define RC5_AR1729_OK       0x002F

#define RC5_AR1729_CHUP     0x0020
#define RC5_AR1729_CHDN     0x0021
#define RC5_AR1729_VOLUP    0x0010
#define RC5_AR1729_VOLDN    0x0011
#define RC5_AR1729_MENU     0x003B

#define RC5_AR1729_TV_VCR   0x003F
#define RC5_AR1729_RECORD   0x003C
#define RC5_AR1729_TV_AC    0x0038
#define RC5_AR1729_STOP     0x002C
#define RC5_AR1729_PLAY     0x002B
#define RC5_AR1729_PAUSE    0x0035
#define RC5_AR1729_RW       0x002E
#define RC5_AR1729_REPLAY   0x0029
#define RC5_AR1729_FF       0x002A

// codes for Digitech Audio remote on default TV setting
#define NEC_0    	  0x0058
#define NEC_1    	  0x0088
#define NEC_2    	  0x0048
#define NEC_3		  0x00C8
#define NEC_4		  0x0028
#define NEC_5		  0x00A8
#define NEC_6		  0x0068
#define NEC_7		  0x00E8
#define NEC_8		  0x0018
#define NEC_9		  0x0098
#define NEC_STANDBY	  0x00C0
#define NEC_MUTE	  0x0080
#define NEC_VOLUP	  0x00B8
#define NEC_VOLDN	  0x0050
#define NEC_MODEUP	  0x00F8
#define NEC_MODEDN	  0x0030
#define NEC_RIGHT	  0x00E0
#define NEC_LEFT	  0x00A0
#define NEC_UP		  0x0020
#define NEC_DOWN	  0x0090

// codes for Altronics A1012 ("DynaLink") remote control on "VCR" setting 115
#define RC5_A1012_VCR_MUTE		0x016D

#define RC5_A1012_VCR_1			0x0141
#define RC5_A1012_VCR_2			0x0142
#define RC5_A1012_VCR_3			0x0143
#define RC5_A1012_VCR_4			0x0144
#define RC5_A1012_VCR_5			0x0145
#define RC5_A1012_VCR_6			0x0146
#define RC5_A1012_VCR_7			0x0147
#define RC5_A1012_VCR_8			0x0148
#define RC5_A1012_VCR_9			0x0149
#define RC5_A1012_VCR_0			0x0140

#define RC5_A1012_VCR_CHUP		0x0160
#define RC5_A1012_VCR_CHDN		0x0161
#define RC5_A1012_VCR_VOLUP		0x0150
#define RC5_A1012_VCR_VOLDN		0x0151

// codes for Jaycar AR1729 Digitech Universal remote on "VCR" setting 916
#define RC5_AR1729_VCR_MUTE     0x014D

#define RC5_AR1729_VCR_1        0x0141
#define RC5_AR1729_VCR_2        0x0142
#define RC5_AR1729_VCR_3        0x0143
#define RC5_AR1729_VCR_4        0x0144
#define RC5_AR1729_VCR_5        0x0145
#define RC5_AR1729_VCR_6        0x0146
#define RC5_AR1729_VCR_7        0x0147
#define RC5_AR1729_VCR_8        0x0148
#define RC5_AR1729_VCR_9        0x0149
#define RC5_AR1729_VCR_0        0x0140

#define RC5_AR1729_VCR_CHUP     0x0160
#define RC5_AR1729_VCR_CHDN     0x0161
#define RC5_AR1729_VCR_VOLUP    0x0150
#define RC5_AR1729_VCR_VOLDN    0x0151

void init_ir();

extern volatile unsigned long ir_final_code;
